(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/lib/api/config.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

// API Service Types
__turbopack_context__.s([
    "API_CONFIG",
    ()=>API_CONFIG,
    "API_ENDPOINTS",
    ()=>API_ENDPOINTS,
    "API_SERVICES",
    ()=>API_SERVICES,
    "API_VERSION",
    ()=>API_VERSION,
    "DEFAULT_HEADERS",
    ()=>DEFAULT_HEADERS,
    "getApiUrl",
    ()=>getApiUrl,
    "getServiceBaseUrl",
    ()=>getServiceBaseUrl,
    "getServiceTimeout",
    ()=>getServiceTimeout,
    "isDevelopment",
    ()=>isDevelopment,
    "isProduction",
    ()=>isProduction
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
const API_SERVICES = {
    ticketing: {
        name: 'Ticketing Service',
        baseURL: ("TURBOPACK compile-time value", "http://34.14.168.219/ticketing-service") || 'http://34.14.168.219/ticketing-service',
        timeout: 30000
    },
    user: {
        name: 'User Service',
        baseURL: ("TURBOPACK compile-time value", "http://34.14.168.219/user-service") || 'http://34.14.168.219/user-service',
        timeout: 30000
    },
    fare: {
        name: 'Fare Service',
        baseURL: ("TURBOPACK compile-time value", "http://34.14.168.219/fare-service") || 'http://34.14.168.219/fare-service',
        timeout: 30000
    }
};
const API_VERSION = 'v1';
const API_ENDPOINTS = {
    // User Service Endpoints
    user: {
        LOGIN: '/api/v1/auth/login',
        SIGNUP: '/api/v1/auth/signup',
        LOGOUT: '/api/v1/auth/logout',
        REFRESH_TOKEN: '/api/v1/auth/refresh',
        USERS: '/api/v1/users',
        USER_BY_ID: (id)=>`/api/v1/users/${id}`,
        PROFILE: '/api/v1/users/profile',
        USER: '/api/v1/users',
        CREATE_USER: '/api/v1/users',
        UPDATE_USER: (id)=>`/api/v1/users/${id}`,
        DELETE_USER: (id)=>`/api/v1/users/${id}`
    },
    // Ticketing Service Endpoints
    ticketing: {
        TICKETS: '/api/v1/tickets',
        TICKET_BY_ID: (id)=>`/api/v1/tickets/${id}`,
        CREATE_TICKET: '/api/v1/tickets/create',
        CANCEL_TICKET: (id)=>`/api/v1/tickets/${id}/cancel`,
        TRIPS: '/api/v1/trips',
        TRIP_BY_ID: (id)=>`/api/v1/trips/${id}/enhanced`,
        SESSIONS: '/api/v1/sessions',
        SESSION_BY_ID: (id)=>`/api/v1/sessions/${id}`,
        DASHBOARD_STATS: '/api/v1/dashboard/stats',
        TRIPS_SESSION: '/api/v1/trips/with-filters',
        CURRENT_USER: '/api/v1/auth/me'
    },
    directions: {
        CREATE_DIRECTIONS: `/api/v1/directions`,
        DIRECTION_STOPS: `/api/v1/direction-stops`
    },
    route: {
        CREATE_ROUTES: `/api/v1/routes`,
        GET_ROUTE_FLL: (id)=>`/api/v1/routes/${id}/structure`,
        FARES_TO_BUS_STOP: (direction_id, from_stop_id)=>`/api/v1/fares/direction/${direction_id}/from-stop/${from_stop_id}`
    },
    trip: {
        TRIPS: `/api/v1/trips`
    },
    permits: {
        ROUTE_PERMITS: `/api/v1/route-permits`,
        CREATE_ROUTE_PERMITS: `/api/v1/route-permits`,
        UPDATE_ROUTE_PERMITS: (id)=>`/api/v1/route-permits/${id}`,
        DELETE_ROUTE_PERMITS: (id)=>`/api/v1/route-permits/${id}`
    },
    bus: {
        BUS: `/api/v1/buses`,
        CREATE_BUS: `/api/v1/buses`,
        BUS_BY_ID: (id)=>`/api/v1/buses/${id}`,
        UPDATE_BUS: (id)=>`/api/v1/buses/${id}`,
        DELETE_BUS: (id)=>`/api/v1/buses/${id}`,
        BUS_ROUTE_ASSIGNMENTS: (id)=>`/api/v1/bus-route-assignments/bus/${id}`,
        BUS_ALL_ASSIGNMENTS: (id)=>`/api/v1/buses/${id}/assignments`,
        ROUTE_ASSIGNMENTS_UPDATE: (id)=>`/api/v1/bus-route-assignments/${id}`,
        ROUTE_ASSIGNMENTS_TO_BUS: `/api/v1/bus-route-assignments`,
        BUS_CREW_ASSIGNMENTS: `/api/v1/bus-crew-assignments`
    },
    busStop: {
        CREATE_BUS_STOP: `/api/v1/stops`
    },
    company: {
        COMPANIES: `/api/v1/companies`,
        CREATE_COMPANY: `/api/v1/companies`,
        UPDATE_COMPANY: (id)=>`/api/v1/companies/${id}`,
        DELETE_COMPANY: (id)=>`/api/v1/companies/${id}`
    },
    // Fare Service Endpoints
    fare: {
        FARES: '/api/fares',
        FARE_BY_ID: (id)=>`/api/fares/${id}`,
        CALCULATE_FARE: '/api/fares/calculate',
        ROUTES: '/api/routes',
        ROUTE_BY_ID: (id)=>`/api/routes/${id}`,
        BUSES: '/api/buses',
        BUS_BY_ID: (id)=>`/api/buses/${id}`
    }
};
const DEFAULT_HEADERS = {
    'Content-Type': 'application/json',
    'Accept': 'application/json'
};
const isDevelopment = ("TURBOPACK compile-time value", "development") === 'development';
const isProduction = ("TURBOPACK compile-time value", "development") === 'production';
const getServiceBaseUrl = (service)=>{
    return API_SERVICES[service].baseURL;
};
const getServiceTimeout = (service)=>{
    return API_SERVICES[service].timeout;
};
const getApiUrl = (service, endpoint)=>{
    return `${getServiceBaseUrl(service)}${endpoint}`;
};
const API_CONFIG = {
    BASE_URL: API_SERVICES.user.baseURL,
    TIMEOUT: 30000,
    VERSION: API_VERSION,
    ENDPOINTS: API_ENDPOINTS.user,
    HEADERS: DEFAULT_HEADERS
};
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/lib/jwt.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "decodeJWT",
    ()=>decodeJWT,
    "getTokenFromStorage",
    ()=>getTokenFromStorage,
    "isTokenExpired",
    ()=>isTokenExpired,
    "removeTokenFromStorage",
    ()=>removeTokenFromStorage,
    "setTokenToStorage",
    ()=>setTokenToStorage
]);
const decodeJWT = (token)=>{
    // Handle null/undefined tokens
    if (!token || typeof token !== 'string') {
        console.warn('Invalid token provided to decodeJWT');
        return null;
    }
    try {
        // Check if it's a mock token (doesn't have proper JWT format)
        if (token.startsWith('mock-jwt-token-')) {
            console.log('📝 Mock token detected, skipping decode');
            return {
                mock: true,
                exp: Math.floor(Date.now() / 1000) + 24 * 60 * 60 // Expires in 24 hours
            };
        }
        // Real JWT decoding
        const parts = token.split('.');
        if (parts.length !== 3) {
            console.warn('Token does not have 3 parts (not a valid JWT)');
            return null;
        }
        const base64Url = parts[1];
        if (!base64Url) {
            console.warn('Token payload is empty');
            return null;
        }
        const base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
        const jsonPayload = decodeURIComponent(atob(base64).split('').map((c)=>'%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2)).join(''));
        return JSON.parse(jsonPayload);
    } catch (error) {
        console.error('Failed to decode JWT:', error);
        return null;
    }
};
const isTokenExpired = (token)=>{
    // Handle null/undefined tokens
    if (!token) {
        return true;
    }
    // Mock tokens never expire
    if (token.startsWith('mock-jwt-token-')) {
        return false;
    }
    const decoded = decodeJWT(token);
    if (!decoded || !decoded.exp) {
        return true;
    }
    return Date.now() >= decoded.exp * 1000;
};
const getTokenFromStorage = ()=>{
    if ("TURBOPACK compile-time truthy", 1) {
        const token = localStorage.getItem('token');
        console.log('📦 Getting token from storage:', token ? 'exists' : 'null');
        return token;
    }
    //TURBOPACK unreachable
    ;
};
const setTokenToStorage = (token)=>{
    if ("TURBOPACK compile-time truthy", 1) {
        console.log('💾 Saving token to storage:', token);
        localStorage.setItem('token', token);
    }
};
const removeTokenFromStorage = ()=>{
    if ("TURBOPACK compile-time truthy", 1) {
        console.log('🗑️ Removing token from storage');
        localStorage.removeItem('token');
        localStorage.removeItem('user');
    }
};
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/lib/api/client.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "apiClient",
    ()=>apiClient,
    "fareClient",
    ()=>fareClient,
    "ticketingClient",
    ()=>ticketingClient,
    "userClient",
    ()=>userClient
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$api$2f$config$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/api/config.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/jwt.ts [app-client] (ecmascript)");
;
;
class ApiClient {
    defaultService = 'user';
    constructor(defaultService = 'user'){
        this.defaultService = defaultService;
    }
    buildHeaders(options) {
        const headers = {
            ...__TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$api$2f$config$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["DEFAULT_HEADERS"],
            ...options.headers
        };
        const token = options.token || (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getTokenFromStorage"])();
        if (token) {
            headers['Authorization'] = `Bearer ${token}`;
        }
        return headers;
    }
    buildUrl(endpoint, params, service) {
        const serviceType = service || this.defaultService;
        const url = (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$api$2f$config$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getApiUrl"])(serviceType, endpoint);
        if (!params) return url;
        const queryParams = new URLSearchParams();
        Object.entries(params).forEach(([key, value])=>{
            queryParams.append(key, String(value));
        });
        const queryString = queryParams.toString();
        return queryString ? `${url}?${queryString}` : url;
    }
    async requestWithTimeout(url, options, timeout) {
        return Promise.race([
            fetch(url, options),
            new Promise((_, reject)=>setTimeout(()=>reject(new Error('Request timeout')), timeout))
        ]);
    }
    async request(endpoint, options = {}) {
        const { method = 'GET', body, params, service, timeout = (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$api$2f$config$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getServiceTimeout"])(service || this.defaultService), credentials = 'same-origin' } = options;
        const url = this.buildUrl(endpoint, params, service);
        const headers = this.buildHeaders(options);
        const serviceName = __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$api$2f$config$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["API_SERVICES"][service || this.defaultService].name;
        console.log(`🌐 [${serviceName}] ${method} ${url}`);
        const config = {
            method,
            headers,
            credentials
        };
        if (body && [
            'POST',
            'PUT',
            'PATCH'
        ].includes(method)) {
            config.body = JSON.stringify(body);
        }
        try {
            const response = await this.requestWithTimeout(url, config, timeout);
            if (response.status === 401) {
                console.warn('⚠️ Unauthorized - clearing token');
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["removeTokenFromStorage"])();
                window.location.href = '/login';
                throw new Error('Unauthorized');
            }
            const data = await response.json().catch(()=>null);
            console.log(data, "sdddddddddddddddddddddddddddd");
            if (!response.ok) {
                const error = {
                    message: data?.error.message || "something went wrong",
                    status: response.status,
                    errors: data?.errors
                };
                console.error(`❌ [${serviceName}] Error:`, error);
                throw error;
            }
            console.log(`✅ [${serviceName}] Response:`, data);
            return {
                data: data.data || data,
                status: response.status,
                message: data?.message,
                success: true
            };
        } catch (error) {
            console.error(`❌ [${serviceName}] Request Failed:`, error);
            if (error.status) {
                throw error;
            }
            throw {
                message: error.message || 'Network error occurred',
                status: 0
            };
        }
    }
    // Convenience methods with service parameter
    async get(endpoint, options = {}) {
        return this.request(endpoint, {
            ...options,
            method: 'GET'
        });
    }
    async post(endpoint, body, options = {}) {
        return this.request(endpoint, {
            ...options,
            method: 'POST',
            body
        });
    }
    async put(endpoint, body, options = {}) {
        return this.request(endpoint, {
            ...options,
            method: 'PUT',
            body
        });
    }
    async patch(endpoint, body, options = {}) {
        return this.request(endpoint, {
            ...options,
            method: 'PATCH',
            body
        });
    }
    async delete(endpoint, options = {}) {
        return this.request(endpoint, {
            ...options,
            method: 'DELETE'
        });
    }
}
const userClient = new ApiClient('user');
const ticketingClient = new ApiClient('ticketing');
const fareClient = new ApiClient('fare');
const apiClient = userClient;
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/services/api.ts [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {

const e = new Error("Could not parse module '[project]/services/api.ts'\n\nExpected ',', got 'CreateCrewAssignment'");
e.code = 'MODULE_UNPARSABLE';
throw e;
}),
"[project]/context/AuthContext.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AuthContext",
    ()=>AuthContext,
    "AuthProvider",
    ()=>AuthProvider
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/services/api.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/jwt.ts [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
'use client';
;
;
;
;
const AuthContext = /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["createContext"])(undefined);
const AuthProvider = ({ children })=>{
    _s();
    const [user, setUser] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [token, setToken] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const [loading, setLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    const router = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"])();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "AuthProvider.useEffect": ()=>{
            const initAuth = {
                "AuthProvider.useEffect.initAuth": ()=>{
                    const storedToken = (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["getTokenFromStorage"])();
                    const storedUser = localStorage.getItem('user');
                    console.log('Initializing auth with token:', storedToken);
                    console.log('Initializing auth with user:', storedUser);
                    if (storedToken && !(0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["isTokenExpired"])(storedToken) && storedUser) {
                        setToken(storedToken);
                        setUser(JSON.parse(storedUser));
                    } else {
                        (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["removeTokenFromStorage"])();
                        localStorage.removeItem('user');
                    }
                    setLoading(false);
                }
            }["AuthProvider.useEffect.initAuth"];
            initAuth();
        }
    }["AuthProvider.useEffect"], []);
    const login = async (credentials)=>{
        try {
            console.log('🔑 Attempting login with:', credentials.email);
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["apiService"].login(credentials);
            console.log('✅ Login response:', response);
            setToken(response.access_token);
            setUser(response.user);
            localStorage.setItem('token', response.access_token);
            localStorage.setItem('user', JSON.stringify(response.user));
            console.log('✅ Auth saved to localStorage');
            console.log('🚀 Forcing redirect to dashboard...');
            // Use timeout to ensure state is saved before redirect
            router.push('/session-view');
        // setTimeout(() => {
        //   window.location.href = '/dashboard';
        // }, 100);
        } catch (error) {
            console.error('❌ Login failed:', error); // Fixed: added error parameter
            // Make sure to throw the error so the login page can catch it
            throw error;
        }
    };
    const signup = async (data)=>{
        try {
            console.log('📝 Attempting signup...');
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["apiService"].signup(data);
            console.log('✅ Signup response:', response);
            setToken(response.access_token);
            setUser(response.user);
            localStorage.setItem('token', response.access_token);
            localStorage.setItem('user', JSON.stringify(response.user));
            console.log('✅ Auth saved, redirecting...');
            setTimeout(()=>{
                window.location.href = '/dashboard';
            }, 100);
        } catch (error) {
            console.error('❌ Signup failed:', error); // Fixed: added error parameter
            throw error;
        }
    };
    const logout = ()=>{
        setToken(null);
        setUser(null);
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$jwt$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["removeTokenFromStorage"])();
        localStorage.removeItem('user');
        router.push('/login');
    };
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(AuthContext.Provider, {
        value: {
            user,
            token,
            loading,
            login,
            signup,
            logout,
            isAuthenticated: !!user && !!token
        },
        children: children
    }, void 0, false, {
        fileName: "[project]/context/AuthContext.tsx",
        lineNumber: 113,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_s(AuthProvider, "PbNA1f39UoOYe1R45Fy24SktfoU=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"]
    ];
});
_c = AuthProvider;
var _c;
__turbopack_context__.k.register(_c, "AuthProvider");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/node_modules/next/dist/compiled/react/cjs/react-jsx-dev-runtime.development.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

/**
 * @license React
 * react-jsx-dev-runtime.development.js
 *
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */ var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
"use strict";
"production" !== ("TURBOPACK compile-time value", "development") && function() {
    function getComponentNameFromType(type) {
        if (null == type) return null;
        if ("function" === typeof type) return type.$$typeof === REACT_CLIENT_REFERENCE ? null : type.displayName || type.name || null;
        if ("string" === typeof type) return type;
        switch(type){
            case REACT_FRAGMENT_TYPE:
                return "Fragment";
            case REACT_PROFILER_TYPE:
                return "Profiler";
            case REACT_STRICT_MODE_TYPE:
                return "StrictMode";
            case REACT_SUSPENSE_TYPE:
                return "Suspense";
            case REACT_SUSPENSE_LIST_TYPE:
                return "SuspenseList";
            case REACT_ACTIVITY_TYPE:
                return "Activity";
            case REACT_VIEW_TRANSITION_TYPE:
                return "ViewTransition";
        }
        if ("object" === typeof type) switch("number" === typeof type.tag && console.error("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."), type.$$typeof){
            case REACT_PORTAL_TYPE:
                return "Portal";
            case REACT_CONTEXT_TYPE:
                return type.displayName || "Context";
            case REACT_CONSUMER_TYPE:
                return (type._context.displayName || "Context") + ".Consumer";
            case REACT_FORWARD_REF_TYPE:
                var innerType = type.render;
                type = type.displayName;
                type || (type = innerType.displayName || innerType.name || "", type = "" !== type ? "ForwardRef(" + type + ")" : "ForwardRef");
                return type;
            case REACT_MEMO_TYPE:
                return innerType = type.displayName || null, null !== innerType ? innerType : getComponentNameFromType(type.type) || "Memo";
            case REACT_LAZY_TYPE:
                innerType = type._payload;
                type = type._init;
                try {
                    return getComponentNameFromType(type(innerType));
                } catch (x) {}
        }
        return null;
    }
    function testStringCoercion(value) {
        return "" + value;
    }
    function checkKeyStringCoercion(value) {
        try {
            testStringCoercion(value);
            var JSCompiler_inline_result = !1;
        } catch (e) {
            JSCompiler_inline_result = !0;
        }
        if (JSCompiler_inline_result) {
            JSCompiler_inline_result = console;
            var JSCompiler_temp_const = JSCompiler_inline_result.error;
            var JSCompiler_inline_result$jscomp$0 = "function" === typeof Symbol && Symbol.toStringTag && value[Symbol.toStringTag] || value.constructor.name || "Object";
            JSCompiler_temp_const.call(JSCompiler_inline_result, "The provided key is an unsupported type %s. This value must be coerced to a string before using it here.", JSCompiler_inline_result$jscomp$0);
            return testStringCoercion(value);
        }
    }
    function getTaskName(type) {
        if (type === REACT_FRAGMENT_TYPE) return "<>";
        if ("object" === typeof type && null !== type && type.$$typeof === REACT_LAZY_TYPE) return "<...>";
        try {
            var name = getComponentNameFromType(type);
            return name ? "<" + name + ">" : "<...>";
        } catch (x) {
            return "<...>";
        }
    }
    function getOwner() {
        var dispatcher = ReactSharedInternals.A;
        return null === dispatcher ? null : dispatcher.getOwner();
    }
    function UnknownOwner() {
        return Error("react-stack-top-frame");
    }
    function hasValidKey(config) {
        if (hasOwnProperty.call(config, "key")) {
            var getter = Object.getOwnPropertyDescriptor(config, "key").get;
            if (getter && getter.isReactWarning) return !1;
        }
        return void 0 !== config.key;
    }
    function defineKeyPropWarningGetter(props, displayName) {
        function warnAboutAccessingKey() {
            specialPropKeyWarningShown || (specialPropKeyWarningShown = !0, console.error("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://react.dev/link/special-props)", displayName));
        }
        warnAboutAccessingKey.isReactWarning = !0;
        Object.defineProperty(props, "key", {
            get: warnAboutAccessingKey,
            configurable: !0
        });
    }
    function elementRefGetterWithDeprecationWarning() {
        var componentName = getComponentNameFromType(this.type);
        didWarnAboutElementRef[componentName] || (didWarnAboutElementRef[componentName] = !0, console.error("Accessing element.ref was removed in React 19. ref is now a regular prop. It will be removed from the JSX Element type in a future release."));
        componentName = this.props.ref;
        return void 0 !== componentName ? componentName : null;
    }
    function ReactElement(type, key, props, owner, debugStack, debugTask) {
        var refProp = props.ref;
        type = {
            $$typeof: REACT_ELEMENT_TYPE,
            type: type,
            key: key,
            props: props,
            _owner: owner
        };
        null !== (void 0 !== refProp ? refProp : null) ? Object.defineProperty(type, "ref", {
            enumerable: !1,
            get: elementRefGetterWithDeprecationWarning
        }) : Object.defineProperty(type, "ref", {
            enumerable: !1,
            value: null
        });
        type._store = {};
        Object.defineProperty(type._store, "validated", {
            configurable: !1,
            enumerable: !1,
            writable: !0,
            value: 0
        });
        Object.defineProperty(type, "_debugInfo", {
            configurable: !1,
            enumerable: !1,
            writable: !0,
            value: null
        });
        Object.defineProperty(type, "_debugStack", {
            configurable: !1,
            enumerable: !1,
            writable: !0,
            value: debugStack
        });
        Object.defineProperty(type, "_debugTask", {
            configurable: !1,
            enumerable: !1,
            writable: !0,
            value: debugTask
        });
        Object.freeze && (Object.freeze(type.props), Object.freeze(type));
        return type;
    }
    function jsxDEVImpl(type, config, maybeKey, isStaticChildren, debugStack, debugTask) {
        var children = config.children;
        if (void 0 !== children) if (isStaticChildren) if (isArrayImpl(children)) {
            for(isStaticChildren = 0; isStaticChildren < children.length; isStaticChildren++)validateChildKeys(children[isStaticChildren]);
            Object.freeze && Object.freeze(children);
        } else console.error("React.jsx: Static children should always be an array. You are likely explicitly calling React.jsxs or React.jsxDEV. Use the Babel transform instead.");
        else validateChildKeys(children);
        if (hasOwnProperty.call(config, "key")) {
            children = getComponentNameFromType(type);
            var keys = Object.keys(config).filter(function(k) {
                return "key" !== k;
            });
            isStaticChildren = 0 < keys.length ? "{key: someKey, " + keys.join(": ..., ") + ": ...}" : "{key: someKey}";
            didWarnAboutKeySpread[children + isStaticChildren] || (keys = 0 < keys.length ? "{" + keys.join(": ..., ") + ": ...}" : "{}", console.error('A props object containing a "key" prop is being spread into JSX:\n  let props = %s;\n  <%s {...props} />\nReact keys must be passed directly to JSX without using spread:\n  let props = %s;\n  <%s key={someKey} {...props} />', isStaticChildren, children, keys, children), didWarnAboutKeySpread[children + isStaticChildren] = !0);
        }
        children = null;
        void 0 !== maybeKey && (checkKeyStringCoercion(maybeKey), children = "" + maybeKey);
        hasValidKey(config) && (checkKeyStringCoercion(config.key), children = "" + config.key);
        if ("key" in config) {
            maybeKey = {};
            for(var propName in config)"key" !== propName && (maybeKey[propName] = config[propName]);
        } else maybeKey = config;
        children && defineKeyPropWarningGetter(maybeKey, "function" === typeof type ? type.displayName || type.name || "Unknown" : type);
        return ReactElement(type, children, maybeKey, getOwner(), debugStack, debugTask);
    }
    function validateChildKeys(node) {
        isValidElement(node) ? node._store && (node._store.validated = 1) : "object" === typeof node && null !== node && node.$$typeof === REACT_LAZY_TYPE && ("fulfilled" === node._payload.status ? isValidElement(node._payload.value) && node._payload.value._store && (node._payload.value._store.validated = 1) : node._store && (node._store.validated = 1));
    }
    function isValidElement(object) {
        return "object" === typeof object && null !== object && object.$$typeof === REACT_ELEMENT_TYPE;
    }
    var React = __turbopack_context__.r("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)"), REACT_ELEMENT_TYPE = Symbol.for("react.transitional.element"), REACT_PORTAL_TYPE = Symbol.for("react.portal"), REACT_FRAGMENT_TYPE = Symbol.for("react.fragment"), REACT_STRICT_MODE_TYPE = Symbol.for("react.strict_mode"), REACT_PROFILER_TYPE = Symbol.for("react.profiler"), REACT_CONSUMER_TYPE = Symbol.for("react.consumer"), REACT_CONTEXT_TYPE = Symbol.for("react.context"), REACT_FORWARD_REF_TYPE = Symbol.for("react.forward_ref"), REACT_SUSPENSE_TYPE = Symbol.for("react.suspense"), REACT_SUSPENSE_LIST_TYPE = Symbol.for("react.suspense_list"), REACT_MEMO_TYPE = Symbol.for("react.memo"), REACT_LAZY_TYPE = Symbol.for("react.lazy"), REACT_ACTIVITY_TYPE = Symbol.for("react.activity"), REACT_VIEW_TRANSITION_TYPE = Symbol.for("react.view_transition"), REACT_CLIENT_REFERENCE = Symbol.for("react.client.reference"), ReactSharedInternals = React.__CLIENT_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE, hasOwnProperty = Object.prototype.hasOwnProperty, isArrayImpl = Array.isArray, createTask = console.createTask ? console.createTask : function() {
        return null;
    };
    React = {
        react_stack_bottom_frame: function(callStackForError) {
            return callStackForError();
        }
    };
    var specialPropKeyWarningShown;
    var didWarnAboutElementRef = {};
    var unknownOwnerDebugStack = React.react_stack_bottom_frame.bind(React, UnknownOwner)();
    var unknownOwnerDebugTask = createTask(getTaskName(UnknownOwner));
    var didWarnAboutKeySpread = {};
    exports.Fragment = REACT_FRAGMENT_TYPE;
    exports.jsxDEV = function(type, config, maybeKey, isStaticChildren) {
        var trackActualOwner = 1e4 > ReactSharedInternals.recentlyCreatedOwnerStacks++;
        if (trackActualOwner) {
            var previousStackTraceLimit = Error.stackTraceLimit;
            Error.stackTraceLimit = 10;
            var debugStackDEV = Error("react-stack-top-frame");
            Error.stackTraceLimit = previousStackTraceLimit;
        } else debugStackDEV = unknownOwnerDebugStack;
        return jsxDEVImpl(type, config, maybeKey, isStaticChildren, debugStackDEV, trackActualOwner ? createTask(getTaskName(type)) : unknownOwnerDebugTask);
    };
}();
}),
"[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
'use strict';
if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
;
else {
    module.exports = __turbopack_context__.r("[project]/node_modules/next/dist/compiled/react/cjs/react-jsx-dev-runtime.development.js [app-client] (ecmascript)");
}
}),
"[project]/node_modules/next/navigation.js [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {

module.exports = __turbopack_context__.r("[project]/node_modules/next/dist/client/components/navigation.js [app-client] (ecmascript)");
}),
]);

//# sourceMappingURL=_d75dcdfc._.js.map